(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3578,        149]*)
(*NotebookOutlinePosition[      4481,        179]*)
(*  CellTagsIndexPosition[      4437,        175]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Using LPT.m: the function Transform", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The Laplace transforms of the simple functions discussed in \[Section]7.1 \
are calculated here by the function ",
  StyleBox["Transform",
    FontWeight->"Bold"],
  " from the package ",
  StyleBox["LPT.m",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Load the package"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(<< Library/Mathematica/Applications/RossDE/LPT.m\)], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples from \[Section]7.1", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[1, t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/s\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[t, t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/s\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[t\^2, t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(2\/s\^3\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[Exp[k\ t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/\(\(-k\) + s\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[Sin[t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/\(1 + s\^2\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[Cos[t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(s\/\(1 + s\^2\)\)], "Output"]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{516, 522},
WindowMargins->{{93, Automatic}, {Automatic, 10}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 103, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1882, 57, 317, 11, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2224, 72, 93, 2, 56, "Section",
  Evaluatable->False],
Cell[2320, 76, 107, 2, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2464, 83, 94, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2583, 89, 77, 2, 27, "Input"],
Cell[2663, 93, 38, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2738, 99, 77, 2, 24, "Input"],
Cell[2818, 103, 41, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2896, 109, 80, 2, 28, "Input"],
Cell[2979, 113, 41, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3057, 119, 85, 2, 24, "Input"],
Cell[3145, 123, 51, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3233, 129, 82, 2, 24, "Input"],
Cell[3318, 133, 49, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3404, 139, 82, 2, 24, "Input"],
Cell[3489, 143, 49, 1, 40, "Output"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

****)

0, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
